﻿/*	VERSION:		1.0		(tested in isolation,  but not tested in any projects)
	
	FUNCTIONS:
		addObject( myObject )											Adds an object to a loopSet.  (and creates a new loopSet if neccessary)
		removeObject( myObject )									Removes an object from a loopSet.
		clear()																		Empties a loopSet.
		pauseObject( myObject, pauseValue )				Pause/resume an object.
		freezeObject( obj, freezeValue )					Prevent the object from being paused / un-paused
		
	OLD loopManagerMC FUNCTIONS:
		addObject( myObject, setName )						Adds an object to a loopSet.  (and creates a new loopSet if neccessary)
		removeObject( myObject, setName )					Removes an object from a loopSet.
		removeSet( setName )											Removes a loopSet.
		pauseSet( setName, pauseValue )						Pause/resume all objects in a loopSet.
		pauseObject( myObject, pauseValue )				Pause/resume an object.
*/
class program.LoopSet extends Array
{
	var pause_obj;
	var _isPaused;
	function LoopSet()
	{
		var _this = this;
		
		// setup pause_obj
		var get_isPaused = function(){
			return _isPaused;
		}// get()
		var set_isPaused = function( newValue ){
			_isPaused = newValue;
			for(var i=0; i<length; i++)
				pauseObject( this[i], newValue );
		}// set()
		pause_obj = {
			isPaused:undefined,
			hasLooped:false,
			freeze:false
		};
		pause_obj.addProperty("isPaused", get_isPaused, set_isPaused);
		pause_obj.isPaused = false;
	}// construct()
	
	
	
	function loop()
	{
		if(pause_obj.isPaused==false)
		{// if:  this loop-set is not paused
			for(var i=0; i<length; i++)
			{// for:  each item in this set
				// clean-up deleted objects
				if(this[i].pause_obj == undefined)
				{// if:  pause object doesn't exist
					// remove this item from this set  (assume it's been deleted & clean-up)
					splice(i, 1);
					i--;
				}// if:  pause object doesn't exist
				
				// run child objects
				else if(this[i].pause_obj.isPaused == false  &&  this[i].pause_obj.hasLooped == false){
					this[i].loop();
					this[i].pause_obj.hasLooped = true;
				}// if:  not paused
			}// for:  each item in this set
		}// if:  this loop-set is not paused
	}// loop()
	
	
	
	function getObjectIndex( obj_ref ){
		for(var i=0; i<length; i++)
			if(this[i] == obj_ref)
				return i;
	}// getObjectIndex()
	
	
	
	function addObject( obj_ref )
	{
		if( getObjectIndex(obj_ref)==undefined )
		{// if:  this object doesn't already exist in this set
			push( obj_ref );
			// add pause_obj if neccessary  (not necessary when adding other loopSets)
			if(!obj_ref.pause_obj)
				obj_ref.pause_obj = {};
			if(obj_ref.pause_obj.isPaused==undefined)
				obj_ref.pause_obj.isPaused = false;
			if(obj_ref.pause_obj.freeze==undefined)
				obj_ref.pause_obj.freeze = false;
			if(obj_ref.pause_obj.hasLooped==undefined)
				obj_ref.pause_obj.hasLooped = false;
			
			return obj_ref;		// return the object to make it convenient to create external shortcut references
		}// if:  this object doesn't already exist in this set
	}// addObject()
	
	
	
	function removeObject( obj_ref ){
		/*for(var i=length-1; i>=0; i--)
			if(this[i] == obj_ref)
				splice( i,1 );*/
		splice( getObjectIndex(obj_ref), 1 );
	}// removeObject()
	
	
	
	function clear(){
		var len = length;
		for(var i=0; i<len; i++)
			pop();
	}// clear()
	
	
	
	static function pauseObject( obj_ref, newValue ){
		if(obj_ref.pause_obj.freeze==false){
			obj_ref.pause_obj.isPaused = newValue;
			if(obj_ref.length!=undefined)					// if: object is an Array
				for(var p=0; p<obj_ref.length; p++)		// for:  each item in this object
					program.LoopSet.pauseObject( obj_ref[p], newValue );
		}// if:  object's state is not frozen
	}// pauseObject()
	
	static function freezeObject( obj_ref, newFreeze){
		obj_ref.pause_obj.freeze = newFreeze || true;
	}// freezeObject()
	
	
	
	function resetLoops()
	{
		for(var i=0; i<length; i++){
			if(this[i].pause_obj.hasLooped == true){
				this[i].pause_obj.hasLooped = false;		// allow this child to be run
				this[i].resetLoops();										// tell child loopSets to allow their children to be run
			}// if:  not already reset  (prevent infinite recusion)
		}// for:  each child object
	}// resetLoops()
	
	
	
	// pause
	function get pause(){
		return pause_obj.isPaused;
	}// get()
	function set pause( newValue ){
		pauseObject( this, newValue );
	}// set()
	
	
	
	// freeze
	function get freeze(){
		return pause_obj.freeze;
	}// get()
	function set freeze( newValue ){
		freezeObject( this, newValue);
	}// set()
}// loopSet class